'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================


Option Explicit

' Set the case direction for the module. Changing
' the value of xCase to false forces the script to convert
' to lowercase.
'Const xCase = True  ' We want to convert to uppercase.
Const xCase = False ' We want to convert to lowercase.
Const Title = "Lowercase converter - by G. Born"

Dim objArgs, param, i

' Try to retrieve the arguments.
Set objArgs = WScript.Arguments    ' Create object.
If objArgs.Count < 1 Then  ' No argument at all. Quit with a dialog box.
    MsgBox "Sorry, no arguments found!" & vbCRLF & _
           "Please drag file(s) or folder(s) to the script's icon.", _
           vbInformation + vbOKOnly, Title
    WScript.Quit  ' Quit script!!!
End If

i = 0
' Try to convert the file to lowercase; count each action.
For Each param In objArgs
    If MakeCase(param, xCase) Then i = i + 1
Next

MsgBox i & " object(s) converted", vbInformation + vbOKOnly, Title
 
Function MakeCase(file, caseFlag)
    Dim fso, oFile, path, name
    Set fso = CreateObject("Scripting.FileSystemObject")

    If fso.FileExists(file) Then
        Set oFile = fso.GetFile(file)
    Else
        If fso.FolderExists(file) Then
            Set oFile = fso.GetFolder(file)
        Else
            MakeCase = False   ' No file system object
            Exit Function
        End If
    End If

    name = fso.GetFileName(file)
    path = fso.GetParentFolderName(file)

    If caseFlag Then
        oFile.Move path & "\" & UCase(name)
    Else
        oFile.Move path & "\" & LCase(name)
    End If
    Set fso = Nothing
    MakeCase = True
End Function

'*** End